import { BuildHandlerOptions, BuildMiddleware } from "@smithy/types";
import { PreviouslyResolved } from "./configuration";
export interface FlexibleChecksumsRequestMiddlewareConfig {
    /**
    /**
     * Indicates an operation requires a checksum in its HTTP request.
     */
    requestChecksumRequired: boolean;
    /**
     * Defines a top-level operation input member that is used to configure request checksum behavior.
     */
    requestAlgorithmMember?: string;
    /**
     * The {@link httpHeader} value for {@link requestAlgorithmMember}, if present.
     * {@link https://smithy.io/2.0/spec/http-bindings.html#httpheader-trait httpHeader}
     */
    requestAlgorithmMemberHttpHeader?: string;
}
export declare const flexibleChecksumsMiddlewareOptions: BuildHandlerOptions;
/**
 * @internal
 */
export declare const flexibleChecksumsMiddleware: (config: PreviouslyResolved, middlewareConfig: FlexibleChecksumsRequestMiddlewareConfig) => BuildMiddleware<any, any>;
